/*
 * Copyright (c) 1999, 2000
 *	Politecnico di Torino.  All rights reserved.
 *
 * Redistribution and use in source and binary forms, with or without
 * modification, are permitted provided that: (1) source code distributions
 * retain the above copyright notice and this paragraph in its entirety, (2)
 * distributions including binary code include the above copyright notice and
 * this paragraph in its entirety in the documentation or other materials
 * provided with the distribution, and (3) all advertising materials mentioning
 * features or use of this software display the following acknowledgement:
 * ``This product includes software developed by the Politecnico
 * di Torino, and its contributors.'' Neither the name of
 * the University nor the names of its contributors may be used to endorse
 * or promote products derived from this software without specific prior
 * written permission.
 * THIS SOFTWARE IS PROVIDED ``AS IS'' AND WITHOUT ANY EXPRESS OR IMPLIED
 * WARRANTIES, INCLUDING, WITHOUT LIMITATION, THE IMPLIED WARRANTIES OF
 * MERCHANTABILITY AND FITNESS FOR A PARTICULAR PURPOSE.
 */

#include "ntddk.h"
#include "ntiologc.h"
#include "ndis.h"

#include "debug.h"
#include "packet.h"


NTSTATUS
PacketOpen(
    IN PDEVICE_OBJECT DeviceObject,
    IN PIRP Irp
    )

{

    PDEVICE_EXTENSION DeviceExtension;

    POPEN_INSTANCE    Open;

    PIO_STACK_LOCATION  IrpSp;

    NDIS_STATUS     Status;
    NDIS_STATUS     ErrorStatus;
    UINT            Medium;
    NDIS_MEDIUM     MediumArray[5];
    UINT            i;
	PUCHAR			tpointer;
    PLIST_ENTRY     PacketListEntry;
	LARGE_INTEGER	TimeFreq;
	LARGE_INTEGER	SystemTime;
	LARGE_INTEGER	PTime;


    IF_LOUD(DbgPrint("Packet: OpenAdapter\n");)

	MediumArray[0]=NdisMedium802_3;
	MediumArray[1]=NdisMediumWan;
	MediumArray[2]=NdisMediumFddi;
	MediumArray[3]=NdisMediumArcnet878_2;
	MediumArray[4]=NdisMediumAtm;




    DeviceExtension = DeviceObject->DeviceExtension;


    IrpSp = IoGetCurrentIrpStackLocation(Irp);


    //
    //  allocate some memory for the open structure
    //
    Open=ExAllocatePool(NonPagedPool,sizeof(OPEN_INSTANCE));


    if (Open==NULL) {
        //
        // no memory
        //
        Irp->IoStatus.Status = STATUS_INSUFFICIENT_RESOURCES;
        IoCompleteRequest(Irp, IO_NO_INCREMENT);
        return STATUS_INSUFFICIENT_RESOURCES;
    }

    RtlZeroMemory(
        Open,
        sizeof(OPEN_INSTANCE)
        );


    //
    //  Save or open here
    //
    IrpSp->FileObject->FsContext=Open;

    Open->DeviceExtension=DeviceExtension;


    //
    //  Save the Irp here for the completeion routine to retrieve
    //
    Open->OpenCloseIrp=Irp;

    //
    //  Allocate a packet pool for our xmit and receive packets
    //
    NdisAllocatePacketPool(
        &Status,
        &Open->PacketPool,
        TRANSMIT_PACKETS,
        sizeof(PACKET_RESERVED));


    if (Status != NDIS_STATUS_SUCCESS) {

        IF_LOUD(DbgPrint("Packet: Failed to allocate packet pool\n");)

        ExFreePool(Open);
        Irp->IoStatus.Status = STATUS_INSUFFICIENT_RESOURCES;
        IoCompleteRequest(Irp, IO_NO_INCREMENT);
        return STATUS_INSUFFICIENT_RESOURCES;
    }

    //
    //  list to hold irp's want to reset the adapter
    //
    InitializeListHead(&Open->ResetIrpList);


    //
    //  Initialize list for holding pending read requests
    //
    KeInitializeSpinLock(&Open->RcvQSpinLock);
    InitializeListHead(&Open->RcvList);

    //
    //  Initialize the request list
    //
    KeInitializeSpinLock(&Open->RequestSpinLock);
    InitializeListHead(&Open->RequestList);


	// get the absolute value of the system boot time.   
	PTime=KeQueryPerformanceCounter(&TimeFreq); 
	KeQuerySystemTime(&SystemTime);
	Open->StartTime.QuadPart=(((SystemTime.QuadPart)%10000000)*TimeFreq.QuadPart)/10000000;
	SystemTime.QuadPart=SystemTime.QuadPart/10000000-11644473600;
	Open->StartTime.QuadPart+=(SystemTime.QuadPart)*TimeFreq.QuadPart-PTime.QuadPart;

	//allocate the circular buffer
	Open->BufSize=0;
	Open->Buffer=NULL;
	Open->Bhead=0;
	Open->Btail=0;
	Open->BLastByte=0;
	Open->Dropped=0;		//reset the dropped packets counter
	Open->Received=0;		//reset the received packets counter
	Open->bpfprogram=NULL;	//reset the filter
	Open->mode=0;
	Open->Nbytes.QuadPart=0;
	Open->Npackets.QuadPart=0;
	Open->Nwrites=1;
	Open->Multiple_Write_Counter=0;

	//allocate and reset the Timeout structures
	KeInitializeDpc(&Open->TotalReadTimeoutDpc,
					ReadTimeout,
					Open);
    KeInitializeTimer(&Open->ReadTimeoutTimer);

	Open->TimeOut=0;
    NdisAllocateSpinLock(&Open->CountersLock);
	NdisInitializeEvent(&Open->WriteEvent);


    //
    //  link up the request stored in our open block
    //
    for (i=0;i<MAX_REQUESTS;i++) {
        ExInterlockedInsertTailList(
            &Open->RequestList,
            &Open->Requests[i].ListElement,
            &Open->RequestSpinLock);

    }


    IoMarkIrpPending(Irp);


    //
    //  Try to open the MAC
    //
    NdisOpenAdapter(
        &Status,
        &ErrorStatus,
        &Open->AdapterHandle,
        &Medium,
        MediumArray,
        5,
        DeviceExtension->NdisProtocolHandle,
        Open,
        &DeviceExtension->AdapterName,
        0,
        NULL);

DbgPrint("\n\nOpen --> 12\n");

    if (Status != NDIS_STATUS_PENDING)
    {
        PacketOpenAdapterComplete(Open,Status,NDIS_STATUS_SUCCESS);
    }

DbgPrint("\n\nOpen --> 13\n");


    return(STATUS_PENDING);
}


VOID
PacketOpenAdapterComplete(
    IN NDIS_HANDLE  ProtocolBindingContext,
    IN NDIS_STATUS  Status,
    IN NDIS_STATUS  OpenErrorStatus
    )

{

    PIRP              Irp;
    POPEN_INSTANCE    Open;

    IF_LOUD(DbgPrint("Packet: OpenAdapterComplete\n");)

    Open= (POPEN_INSTANCE)ProtocolBindingContext;

    //
    //  get the open irp
    //
    Irp=Open->OpenCloseIrp;

    if (Status != NDIS_STATUS_SUCCESS) {

        IF_LOUD(DbgPrint("Packet: OpenAdapterComplete-FAILURE\n");)

        NdisFreePacketPool(Open->PacketPool);

        ExFreePool(Open);

    }

    Irp->IoStatus.Status = Status;
    Irp->IoStatus.Information = 0;
    IoCompleteRequest(Irp, IO_NO_INCREMENT);

    return;

}




NTSTATUS
PacketClose(
    IN PDEVICE_OBJECT DeviceObject,
    IN PIRP Irp
    )

{

    POPEN_INSTANCE    Open;
    NDIS_STATUS     Status;
    PIO_STACK_LOCATION  IrpSp;

    IF_LOUD(DbgPrint("Packet: CloseAdapter\n");)

    IrpSp = IoGetCurrentIrpStackLocation(Irp);

    Open=IrpSp->FileObject->FsContext;

	//
	//cancel the timer event associated with the read
	//
	KeCancelTimer(&Open->ReadTimeoutTimer); 

    //
    //  Save the IRP
    //
    Open->OpenCloseIrp=Irp;

    IoMarkIrpPending(Irp);

    //
    //  close the adapter
    //
    NdisCloseAdapter(
        &Status,
        Open->AdapterHandle
	    );


    if (Status != NDIS_STATUS_PENDING) {

        PacketCloseAdapterComplete(
            Open,
            Status
            );
        return STATUS_SUCCESS;

    }

    return(STATUS_PENDING);

}




VOID
PacketCloseAdapterComplete(
    IN NDIS_HANDLE  ProtocolBindingContext,
    IN NDIS_STATUS  Status
    )

{
    POPEN_INSTANCE    Open;
    PIRP              Irp;

    IF_LOUD(DbgPrint("Packet: CloseAdapterComplete\n");)

    Open= (POPEN_INSTANCE)ProtocolBindingContext;

	//free the bpf program
	if(Open->bpfprogram!=NULL)ExFreePool(Open->bpfprogram);

	//free the buffer
	Open->BufSize=0;
	if(Open->Buffer!=NULL)ExFreePool(Open->Buffer);


    Irp=Open->OpenCloseIrp;

    NdisFreePacketPool(Open->PacketPool);

    ExFreePool(Open);

    Irp->IoStatus.Status = STATUS_SUCCESS;
    Irp->IoStatus.Information = 0;
    IoCompleteRequest(Irp, IO_NO_INCREMENT);

    return;

}


VOID
PacketResetComplete(
    IN NDIS_HANDLE  ProtocolBindingContext,
    IN NDIS_STATUS  Status
    )

{
    POPEN_INSTANCE      Open;
    PIRP                Irp;

    PLIST_ENTRY         ResetListEntry;

    IF_LOUD(DbgPrint("Packet: PacketResetComplte\n");)

    Open= (POPEN_INSTANCE)ProtocolBindingContext;


    //
    //  remove the reset IRP from the list
    //
    ResetListEntry=ExInterlockedRemoveHeadList(
                       &Open->ResetIrpList,
                       &Open->RequestSpinLock
                       );

#if DBG
    if (ResetListEntry == NULL) {
        DbgBreakPoint();
        return;
    }
#endif

    Irp=CONTAINING_RECORD(ResetListEntry,IRP,Tail.Overlay.ListEntry);

    Irp->IoStatus.Status = STATUS_SUCCESS;
    IoCompleteRequest(Irp, IO_NO_INCREMENT);

    IF_LOUD(DbgPrint("Packet: PacketResetComplte exit\n");)

    return;

}
