/*
 * Copyright (c) 1999, 2000
 *	Politecnico di Torino.  All rights reserved.
 *
 * Redistribution and use in source and binary forms, with or without
 * modification, are permitted provided that: (1) source code distributions
 * retain the above copyright notice and this paragraph in its entirety, (2)
 * distributions including binary code include the above copyright notice and
 * this paragraph in its entirety in the documentation or other materials
 * provided with the distribution, and (3) all advertising materials mentioning
 * features or use of this software display the following acknowledgement:
 * ``This product includes software developed by the Politecnico
 * di Torino, and its contributors.'' Neither the name of
 * the University nor the names of its contributors may be used to endorse
 * or promote products derived from this software without specific prior
 * written permission.
 * THIS SOFTWARE IS PROVIDED ``AS IS'' AND WITHOUT ANY EXPRESS OR IMPLIED
 * WARRANTIES, INCLUDING, WITHOUT LIMITATION, THE IMPLIED WARRANTIES OF
 * MERCHANTABILITY AND FITNESS FOR A PARTICULAR PURPOSE.
 */

#ifndef lint
static const char rcsid[] =
    "@(#) $Header: pcap-win32.c,v 1.0 99/06/25 04:26:11 leres Exp $ (LBL)";
#endif

#include <windows.h>
#include "pcap-int.h"
#include <packet32.h>

#define  MAX_PACKET_LENGTH 1514  /*MAC ethernet/802.3)*/
#define	 PcapBufSize 256000	/*dimension of the buffer in the pcap_t structure*/
int SIZE_BUF=1000000;

/*start winsock*/
int wsockinit()
{
	WORD wVersionRequested;
	WSADATA wsaData;
	int err;
	wVersionRequested = MAKEWORD( 1, 1); 
	err = WSAStartup( wVersionRequested, &wsaData );
	if ( err != 0 )
	{
		return 1;
	}
	return 0;
}

/*set the driver's working mode*/
int pcap_setmode(pcap_t *p, int mode){

	if(PacketSetMode(p->adapter,mode)==FALSE)
	{
		sprintf(p->errbuf, "driver error: working mode not recognized");
		return -1;
	}

	return 0;
}

int
pcap_setbuff(pcap_t *p, int dim)
{
	if(PacketSetBuff(p->adapter,dim)==FALSE)
		{
		sprintf(p->errbuf, "driver error: not enough memory to allocate the buffer");
		return -1;
		}
	return 0;
}


int
pcap_stats(pcap_t *p, struct pcap_stat *ps)
{
	struct bpf_stat s;

	if(PacketGetStats(p->adapter,&s)!=TRUE){
		sprintf(p->errbuf, "PacketGetStats error");
		return -1;
	}

	ps->ps_recv = s.bs_recv;
	ps->ps_drop = s.bs_drop;
	return (0);
}

int
pcap_read(pcap_t *p, int cnt, pcap_handler callback, u_char *user)
{
	int cc;
	int n = 0;
	register u_char *bp, *ep;

	cc = p->cc;
	if (p->cc == 0) {

	    /* capture the packets */
		if(PacketReceivePacket(p->adapter,p->Packet,TRUE)==FALSE){
			sprintf(p->errbuf, "read error: PacketReceivePacket failed");
			return (-1);
		}
			
		cc = p->Packet->ulBytesReceived;

		bp = p->buffer;
	} 
	else
		bp = p->bp;

	/*
	 * Loop through each packet.
	 */
#define bhp ((struct bpf_hdr *)bp)
	ep = bp + cc;
	while (bp < ep) {
		register int caplen, hdrlen;
		caplen = bhp->bh_caplen;
		hdrlen = bhp->bh_hdrlen;

		/*
		 * XXX A bpf_hdr matches a pcap_pkthdr.
		 */
		(*callback)(user, (struct pcap_pkthdr*)bp, bp + hdrlen);
		bp += BPF_WORDALIGN(caplen + hdrlen);
		if (++n >= cnt && cnt > 0) {
			p->bp = bp;
			p->cc = ep - bp;
			return (n);
		}
	}
#undef bhp
	p->cc = 0;
	return (n);
}


pcap_t *
pcap_open_live(char *device, int snaplen, int promisc, int to_ms, char *ebuf)
{
	register pcap_t *p;
	NetType type;

	p = (pcap_t *)malloc(sizeof(*p));
	if (p == NULL) {
		sprintf(ebuf, "malloc: %s", pcap_strerror(errno));
		return (NULL);
	}
	memset(p, 0, sizeof(*p));
	p->adapter=NULL;

	p->adapter=PacketOpenAdapter(device);
	if (p->adapter==NULL) {strcpy(ebuf,"Error opening adapter");return NULL;}

	if (promisc) PacketSetHwFilter(p->adapter,NDIS_PACKET_TYPE_PROMISCUOUS);
	 else PacketSetHwFilter(p->adapter,NDIS_PACKET_TYPE_DIRECTED);
	
	/*get network type*/
	if(PacketGetNetType (p->adapter,&type)==FALSE)
	{
		sprintf(ebuf, "Cannot determine the network type");
		goto bad;
	}
	
	/*Set the linktype*/
	switch (type.LinkType) {

	case NdisMediumWan:			/*PPP connection under win9x*/
/*		p->linktype = DLT_PPP_WIN32; */
		p->linktype = DLT_EN10MB; 
		
	break;

	case NdisMedium802_3:
/*
		if(type.LinkSpeed==100000000)
			p->linktype = DLT_EN100MB;
		else if (type.LinkSpeed==10000000)
			p->linktype = DLT_EN10MB;
		else
			p->linktype = DLT_PPP_WIN32;	//PPP connection in winNTx
*/
		p->linktype = DLT_EN10MB;
	break;

	case NdisMediumFddi:
			p->linktype = DLT_FDDI;
	break;

	case NdisMediumArcnet878_2:
			p->linktype = DLT_ARCNET;
	break;

	case NdisMediumAtm:
			p->linktype = DLT_ATM_RFC1483;
	break;

	default:
		p->linktype = DLT_EN10MB;			/*an unknown adapter is assumed to be ethernet*/
	}

	/* Leave room for link header */
	p->bufsize = PcapBufSize;

	p->buffer = (u_char *)malloc(PcapBufSize);
	if (p->buffer == NULL) {
		sprintf(ebuf, "malloc: %s", pcap_strerror(errno));
		goto bad;
	}

	p->snapshot = snaplen;

	/* allocate packet structure used during the capture */
	if((p->Packet = PacketAllocatePacket())==NULL){
		sprintf(ebuf, "failed to allocate the PACKET structure");
		goto bad;
	}

	PacketInitPacket(p->Packet,(BYTE*)p->buffer,p->bufsize);

	/* allocate the buffer in the driver */
	if(PacketSetBuff(p->adapter,SIZE_BUF)==FALSE)
		{
			sprintf(ebuf,"driver error: not enough memory to allocate the buffer\n");
			goto bad;
		}

	PacketSetReadTimeout(p->adapter,to_ms);

	return (p);
bad:
	if (p->adapter)
	    PacketCloseAdapter(p->adapter);
	if (p->buffer != NULL)
		free(p->buffer);
	free(p);
	return (NULL);
}


int
pcap_setfilter(pcap_t *p, struct bpf_program *fp)
{
	if(p->adapter==NULL)
		p->fcode = *fp;
	else if(PacketSetBpf(p->adapter,fp)==FALSE){
		/* kernel filter not installed. */
		sprintf(p->errbuf, "Driver error: cannot set bpf filter.");
		return (-1);
	}
	return (0);
}

